<?php
/**
 * Payment Handler for Midtrans
 *
 * This script is called via AJAX from the payment page. It communicates
 * with the Midtrans API to create a secure transaction token (Snap Token)
 * and returns it to the front-end to open the payment widget.
 */

header('Content-Type: application/json');

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once '../config.php';
require_once '../vendor/autoload.php';
require_once '../app/helpers.php';

// 1. SECURITY CHECKS
if (!is_logged_in() || $_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['error' => 'Unauthorized access.']);
    exit();
}

// 2. CONFIGURE MIDTRANS
\Midtrans\Config::$serverKey = MIDTRANS_SERVER_KEY;
\Midtrans\Config::$isProduction = MIDTRANS_IS_PRODUCTION;
\Midtrans\Config::$isSanitized = true;
\Midtrans\Config::$is3ds = true;

// 3. PREPARE TRANSACTION DETAILS
$user_id = $_SESSION['user_id'];
$order_id = 'AINTERVIEW-' . $user_id . '-' . time();
$amount = 19900; // Amount should be fixed on the server-side for security

$transaction_details = [
    'order_id' => $order_id,
    'gross_amount' => $amount,
];

// Get user details from session
$customer_details = [
    'first_name' => $_SESSION['user_name'] ?? 'Guest',
    'email' => $_SESSION['user_email'] ?? '',
];

$item_details = [[
    'id' => 'AI-SERVICE-01',
    'price' => $amount,
    'quantity' => 1,
    'name' => 'AI Interview & Profile Analysis'
]];

// 4. CREATE TRANSACTION RECORD IN OUR DATABASE
try {
    $pdo = get_db_connection();
    $stmt = $pdo->prepare("INSERT INTO transactions (user_id, order_id, amount, status) VALUES (?, ?, ?, 'pending')");
    $stmt->execute([$user_id, $order_id, $amount]);
} catch (Exception $e) {
    echo json_encode(['error' => 'Failed to create transaction record: ' . $e->getMessage()]);
    exit();
}

// 5. GET SNAP TOKEN FROM MIDTRANS
try {
    $params = [
        'transaction_details' => $transaction_details,
        'customer_details' => $customer_details,
        'item_details' => $item_details,
    ];
    $snapToken = \Midtrans\Snap::getSnapToken($params);
    echo json_encode(['token' => $snapToken]);
} catch (Exception $e) {
    echo json_encode(['error' => 'Failed to get payment token: ' . $e->getMessage()]);
}

