<?php
/**
 * Logout Handler (Multi-purpose)
 *
 * This script handles the logout process for both regular users and administrators.
 * It checks for a 'from' parameter to determine the correct redirection page.
 */

// 1. Start the session to be able to destroy it.
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 2. Determine the correct redirect location.
// -----------------------------------------------------------------------------
$from = $_GET['from'] ?? 'user';
$redirect_location = '';

if ($from === 'admin') {
    // If the logout was initiated from the admin panel, redirect to the admin login page.
    $redirect_location = 'admin/index.php?page=login';
} else {
    // Otherwise, for all other cases, redirect to the standard user login page.
    $redirect_location = 'index.php?page=login';
}

// 3. Unset all session variables.
$_SESSION = array();

// 4. Destroy the session cookie.
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// 5. Destroy the session.
session_destroy();

// 6. Redirect to the determined location.
header('Location: ' . $redirect_location);
exit();

