<?php
/**
 * Partial: Formulir Tes Psikologi PAPI Kostick
 *
 * File ini berisi HTML dan logika front-end untuk menampilkan
 * formulir tes PAPI Kostick (90 pertanyaan).
 * File ini di-include oleh file `v1/pages/psy_test.php`.
 *
 * PENTING: File ini TIDAK berisi tag <form> atau tombol submit.
 * Tag <form> dan tombol submit ada di file induknya (`psy_test.php`),
 * yang membungkus file partial ini.
 */
?>

<style>
    .papi-instructions {
        padding: 15px;
        background-color: #f8f9fa;
        border: 1px solid #e0e0e0;
        border-radius: 8px;
    }
    .papi-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    .papi-table th, .papi-table td {
        padding: 12px 15px;
        text-align: left;
        border: 1px solid #ddd;
    }
    .papi-table th {
        background-color: #f7f7f7;
        width: 50%; /* Bagi dua kolom sama rata */
    }
    .papi-table tr.question-row td:first-child {
        /* Latar belakang abu-abu untuk memisahkan A dan B */
        background-color: #fdfdfd; 
    }
    .papi-table tr.question-row td:last-child {
        background-color: #f5f5f5;
    }
    .papi-table .q-number {
        font-weight: bold;
        font-size: 1.1em;
        color: #333;
        display: block;
        margin-bottom: 8px;
    }
    .papi-table label {
        display: flex;
        align-items: center;
        cursor: pointer;
        font-weight: normal;
        margin-bottom: 0;
    }
    .papi-table input[type="radio"] {
        margin-right: 10px;
        transform: scale(1.1);
    }
</style>

<div class="papi-instructions mb-4">
    <h4>Petunjuk Pengerjaan Tes PAPI Kostick</h4>
    <p>Berikut adalah 90 pasang pernyataan. Untuk setiap pasang pernyataan, Anda harus:</p>
    <ul>
        <li>Memilih <strong>satu (1) pernyataan</strong> yang Anda rasa <strong>paling sesuai</strong> atau paling menggambarkan diri Anda.</li>
        <li>Anda tidak boleh melewatkan satu nomor pun.</li>
    </ul>
    <p>Pilihlah dengan cepat dan jujur berdasarkan kesan pertama Anda.</p>
</div>

<hr>

<table class="papi-table">
    <thead>
        <tr>
            <th>Pilihan A</th>
            <th>Pilihan B</th>
        </tr>
    </thead>
    <tbody>

        <tr class="question-row">
            <td>
                <span class="q-number">Pertanyaan 1</span>
                <label>
                    <input type="radio" name="papi_q[1]" value="A" required>
                    Saya adalah seorang pekerja keras
                </label>
            </td>
            <td>
                <span class="q-number">&nbsp;</span> <label>
                    <input type="radio" name="papi_q[1]" value="B" required>
                    Saya bukan seorang pemurung
                </label>
            </td>
        </tr>

        <tr class="question-row">
            <td>
                <span class="q-number">Pertanyaan 2</span>
                <label>
                    <input type="radio" name="papi_q[2]" value="A" required>
                    Saya suka bekerja lebih baik dari orang lain
                </label>
            </td>
            <td>
                <span class="q-number">&nbsp;</span> <label>
                    <input type="radio" name="papi_q[2]" value="B" required>
                    Saya suka menunjukkan kepada orang lain cara melakukan sesuatu
                </label>
            </td>
        </tr>

        <tr class="question-row">
            <td>
                <span class="q-number">Pertanyaan 3</span>
                <label>
                    <input type="radio" name="papi_q[3]" value="A" required>
                    Saya suka mencoba hal-hal baru
                </label>
            </td>
            <td>
                <span class="q-number">&nbsp;</span> <label>
                    <input type="radio" name="papi_q[3]" value="B" required>
                    Saya suka membereskan pekerjaan sampai selesai
                </label>
            </td>
        </tr>
        
        <tr class="question-row">
            <td>
                <span class="q-number">Pertanyaan 4</span>
                <label>
                    <input type="radio" name="papi_q[4]" value="A" required>
                    Saya suka berteman dekat dengan orang lain
                </label>
            </td>
            <td>
                <span class="q-number">&nbsp;</span> <label>
                    <input type="radio" name="papi_q[4]" value="B" required>
                    Saya adalah pemimpin yang baik
                </label>
            </td>
        </tr>

        <tr class="question-row">
            <td>
                <span class="q-number">Pertanyaan 5</span>
                <label>
                    <input type="radio" name="papi_q[5]" value="A" required>
                    Saya suka memikirkan ide-ide baru
                </label>
            </td>
            <td>
                <span class="q-number">&nbsp;</span> <label>
                    <input type="radio" name="papi_q[5]" value="B" required>
                    Saya orang yang sangat teratur
                </label>
            </td>
        </tr>

        <tr class="question-row">
            <td>
                <span class="q-number">Pertanyaan 88</span>
                <label>
                    <input type="radio" name="papi_q[88]" value="A" required>
                    Saya mudah merasa cemas
                </label>
            </td>
            <td>
                <span class="q-number">&nbsp;</span> <label>
                    <input type="radio" name="papi_q[88]" value="B" required>
                    Saya suka mengambil keputusan
                </label>
            </td>
        </tr>

        <tr class="question-row">
            <td>
                <span class="q-number">Pertanyaan 89</span>
                <label>
                    <input type="radio" name="papi_q[89]" value="A" required>
                    Saya suka bekerja dengan detil
                </label>
            </td>
            <td>
                <span class="q-number">&nbsp;</span> <label>
                    <input type="radio" name="papi_q[89]" value="B" required>
                    Saya suka menyenangkan atasan saya
                </label>
            </td>
        </tr>

        <tr class="question-row">
            <td>
                <span class="q-number">Pertanyaan 90</span>
                <label>
                    <input type="radio" name="papi_q[90]" value="A" required>
                    Saya orang yang bersemangat
                </label>
            </td>
            <td>
                <span class="q-number">&nbsp;</span> <label>
                    <input type="radio" name="papi_q[90]" value="B" required>
                    Saya berusaha keras
                </label>
            </td>
        </tr>

    </tbody>
</table>