<?php
// Set header to display as a webpage
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kebijakan Privasi - AInterview.id</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.8;
            color: #333;
            background-color: #f9f9f9;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: 20px auto;
            background-color: #fff;
            padding: 40px;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        }
        h1, h2 {
            color: #2c3e50;
            border-bottom: 2px solid #3498db;
            padding-bottom: 10px;
        }
        h1 { font-size: 2.5em; }
        h2 { font-size: 1.8em; margin-top: 40px; }
        strong { color: #2c3e50; }
        a { color: #3498db; text-decoration: none; }
        a:hover { text-decoration: underline; }
        .last-updated { color: #777; font-style: italic; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Kebijakan Privasi AInterview.id</h1>
        <p class="last-updated">Terakhir diperbarui: 7 Oktober 2025</p>

        <p>Selamat datang di AInterview.id ("kami", "milik kami", atau "kita"). Kami berkomitmen untuk melindungi privasi Anda. Kebijakan Privasi ini menjelaskan bagaimana kami mengumpulkan, menggunakan, mengungkapkan, dan melindungi informasi Anda saat Anda menggunakan layanan kami, termasuk situs web kami (https://ainterview.id/v1/), wawancara AI, dan layanan terkait (secara kolektif disebut "Layanan").</p>
        <p>Dengan menggunakan Layanan kami, Anda menyetujui pengumpulan dan penggunaan informasi sesuai dengan kebijakan ini.</p>

        <h2>1. Informasi yang Kami Kumpulkan</h2>
        <p>Kami mengumpulkan beberapa jenis informasi untuk berbagai tujuan guna menyediakan dan meningkatkan Layanan kami kepada Anda.</p>
        
        <h3>a. Data Pribadi yang Anda Berikan</h3>
        <ul>
            <li><strong>Informasi Akun:</strong> Saat Anda mendaftar, kami mengumpulkan nama lengkap, alamat email, dan kredensial login Anda (kata sandi yang di-hash atau token Google SSO).</li>
            <li><strong>Dokumen Pengguna:</strong> Kami mengumpulkan file yang Anda unggah, termasuk Curriculum Vitae (CV) dan iklan lowongan pekerjaan.</li>
            <li><strong>Data Wawancara:</strong> Kami mengumpulkan dan memproses rekaman video dan audio dari sesi wawancara AI Anda, termasuk transkrip teks dari jawaban Anda.</li>
            <li><strong>Data Pembayaran:</strong> Kami menggunakan pemroses pembayaran pihak ketiga (misalnya, Midtrans, Xendit) untuk menangani transaksi. Kami tidak menyimpan informasi kartu kredit Anda.</li>
        </ul>

        <h3>b. Data dari Google Drive</h3>
        <p>Jika Anda memberikan izin, kami akan mengakses folder Google Drive yang telah Anda tentukan ("Job Posters" dan "CVs") untuk tujuan "pembelajaran" AI kami. Kami hanya akan mengakses file dalam folder-folder ini dan tidak akan mengakses data lain di Google Drive Anda.</p>

        <h2>2. Bagaimana Kami Menggunakan Informasi Anda</h2>
        <p>Kami menggunakan informasi yang kami kumpulkan untuk tujuan berikut:</p>
        <ul>
            <li><strong>Untuk Menyediakan dan Memelihara Layanan:</strong> Untuk mengelola akun Anda, memproses unggahan, dan melakukan sesi wawancara AI.</li>
            <li><strong>Untuk Personalisasi Pengalaman Anda:</strong> Untuk menyesuaikan pertanyaan wawancara AI berdasarkan CV Anda, iklan pekerjaan yang relevan, dan hasil tes psikologi.</li>
            <li><strong>Untuk Peningkatan AI dan Layanan:</strong> Kami menggunakan konten anonim dari CV, iklan pekerjaan, dan transkrip wawancara untuk melatih dan meningkatkan akurasi serta relevansi model AI kami.</li>
            <li><strong>Untuk Tujuan Komersial:</strong> Kami membuat profil kandidat anonim yang berisi hasil wawancara dan penilaian psikologis. Profil ini dapat kami sediakan secara komersial kepada layanan perekrutan pihak ketiga yang terverifikasi. Kami tidak akan pernah membagikan nama, alamat email, atau informasi kontak langsung Anda tanpa persetujuan eksplisit dari Anda.</li>
            <li><strong>Untuk Komunikasi:</strong> Untuk menghubungi Anda dengan pembaruan, pemberitahuan, atau informasi pemasaran (jika Anda memilih untuk menerimanya).</li>
        </ul>

        <h2>3. Berbagi dan Pengungkapan Data</h2>
        <p>Kami tidak menjual data pribadi Anda. Kami dapat membagikan informasi Anda dalam situasi berikut:</p>
        <ul>
            <li><strong>Dengan Penyedia Layanan:</strong> Kami dapat membagikan informasi dengan perusahaan pihak ketiga yang membantu kami mengoperasikan Layanan (misalnya, penyedia hosting, API AI, pemroses pembayaran).</li>
            <li><strong>Untuk Profil Komersial:</strong> Seperti yang dijelaskan di atas, kami membagikan profil kandidat anonim dengan mitra perekrutan.</li>
            <li><strong>Untuk Kepatuhan Hukum:</strong> Kami dapat mengungkapkan informasi Anda jika diwajibkan oleh hukum atau sebagai tanggapan atas permintaan yang sah dari otoritas publik.</li>
        </ul>

        <h2>4. Keamanan Data</h2>
        <p>Keamanan data Anda penting bagi kami. Kami menggunakan langkah-langkah keamanan teknis dan organisasi yang wajar untuk melindungi Data Pribadi Anda dari akses, penggunaan, atau pengungkapan yang tidak sah. Namun, tidak ada metode transmisi melalui Internet atau penyimpanan elektronik yang 100% aman.</p>

        <h2>5. Hak Anda</h2>
        <p>Anda memiliki hak-hak tertentu mengenai data pribadi Anda, termasuk hak untuk mengakses, memperbaiki, atau menghapus informasi yang kami miliki tentang Anda. Silakan hubungi kami untuk menggunakan hak-hak ini.</p>

        <h2>6. Privasi Anak-Anak</h2>
        <p>Layanan kami tidak ditujukan untuk siapa pun yang berusia di bawah 18 tahun. Kami tidak secara sadar mengumpulkan informasi yang dapat diidentifikasi secara pribadi dari anak di bawah umur.</p>

        <h2>7. Perubahan pada Kebijakan Privasi Ini</h2>
        <p>Kami dapat memperbarui Kebijakan Privasi kami dari waktu ke waktu. Kami akan memberitahu Anda tentang perubahan apa pun dengan memposting Kebijakan Privasi baru di halaman ini.</p>

        <h2>8. Hubungi Kami</h2>
        <p>Jika Anda memiliki pertanyaan tentang Kebijakan Privasi ini, silakan hubungi kami melalui email di: <strong>legal@ainterview.id</strong>.</p>
    </div>
</body>
</html>

