<?php
/**
 * Admin Page: Edit Psychological Test
 *
 * PERBAIKAN: Path 'include' telah dikoreksi untuk mencocokkan
 * struktur file Anda (tanpa direktori 'partials').
 */

// Mengubah path dari 'admin/partials/admin_header.php'
include THEME_PATH . 'admin/header.php';

// 1. Ambil ID Tes dari URL
$test_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$test = null;

if (!$test_id) {
    display_error_message("Invalid Test ID. Cannot edit.");
} else {
    // 2. Ambil data tes saat ini dari database
    try {
        $pdo = get_db_connection();
        $stmt = $pdo->prepare("SELECT * FROM psychological_tests WHERE id = ?");
        $stmt->execute([$test_id]);
        $test = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$test) {
            display_error_message("Test not found. It may have been deleted.");
        }
    } catch (Exception $e) {
        display_error_message("Database error: " . $e->getMessage());
        $test = null;
    }
}
?>

<div class="content-wrapper">
    <div class="container-fluid">
        
        <div class="row mb-3">
            <div class="col-md-12">
                <h1><i class="fas fa-edit"></i> Edit Psychological Test</h1>
                <p>Ubah detail untuk tes yang ada.</p>
            </div>
        </div>
        
        <?php
        if (isset($_SESSION['success_message'])) {
            echo '<div class="alert alert-success">' . htmlspecialchars($_SESSION['success_message']) . '</div>';
            unset($_SESSION['success_message']);
        }
        if (isset($_SESSION['error_message'])) {
            echo '<div class="alert alert-danger">' . htmlspecialchars($_SESSION['error_message']) . '</div>';
            unset($_SESSION['error_message']);
        }
        ?>

        <?php if ($test): // Hanya tampilkan formulir jika tes berhasil ditemukan ?>
        <div class="card">
            <div class="card-header">
                <i class="fas fa-pencil-alt"></i> Edit Details for '<?php echo htmlspecialchars($test['test_name']); ?>'
            </div>
            <div class="card-body">
                <form action="actions/test_management_handler.php" method="POST">
                    <input type="hidden" name="action" value="edit_test">
                    <input type="hidden" name="test_id" value="<?php echo (int)$test['id']; ?>">

                    <div class="form-group">
                        <label for="test_name">Test Name</label>
                        <input type="text" class="form-control" id="test_name" name="test_name" 
                               value="<?php echo htmlspecialchars($test['test_name']); ?>" required>
                        <small class="form-text text-muted">Nama tes yang akan dilihat oleh admin dan pengguna.</small>
                    </div>

                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description" rows="3"><?php echo htmlspecialchars($test['description']); ?></textarea>
                    </div>

                    <div class="form-group">
                        <label for="test_type">Test Type</label>
                        <select class="form-control" id="test_type" name="test_type">
                            <?php
                            $types = [
                                'simple' => 'Simple (Manual Questions)',
                                'disc' => 'DISC (Built-in Logic)',
                                'papi' => 'PAPI Kostick (Built-in Logic)'
                            ];
                            
                            foreach ($types as $value => $label) {
                                $selected = ($test['test_type'] === $value) ? 'selected' : '';
                                echo "<option value=\"{$value}\" {$selected}>{$label}</option>";
                            }
                            ?>
                        </select>
                        <small class="form-text text-muted">
                            <b>Penting:</b> Mengubah ini untuk tes yang ada mungkin memiliki konsekuensi.
                        </small>
                    </div>

                    <hr>
                    
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save Changes
                    </button>
                    <a href="index.php?page=tests" class="btn btn-secondary">
                        <i class="fas fa-times"></i> Cancel
                    </a>
                    
                </form>
            </div>
        </div>
        <?php endif; ?>
        
    </div> </div> <?php
// Mengubah path dari 'admin/partials/admin_footer.php'
include THEME_PATH . 'admin/footer.php';
?>