<?php
/**
 * Admin Login Page
 *
 * This is the theme file for the administrator login screen.
 * The main controller (admin/index.php) is responsible for loading core files
 * like config.php and helpers.php before including this template.
 */

// We do not need to require config.php or helpers.php here
// because the main router (admin/index.php) has already loaded them.

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - <?php echo e(SITE_NAME); ?></title>
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <!-- Main Stylesheet for Admin Login -->
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .login-container {
            background-color: #ffffff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
            text-align: center;
        }
        .login-header {
            margin-bottom: 30px;
        }
        .login-header .icon {
            font-size: 48px;
            color: #4A90E2;
            margin-bottom: 15px;
        }
        .login-header h1 {
            margin: 0;
            font-size: 24px;
            color: #333;
            font-weight: 700;
        }
        .login-header p {
            margin: 5px 0 0;
            color: #777;
        }
        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #555;
        }
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border-radius: 8px;
            border: 1px solid #ddd;
            font-size: 16px;
            box-sizing: border-box;
            transition: border-color 0.3s;
        }
        .form-control:focus {
            outline: none;
            border-color: #4A90E2;
            box-shadow: 0 0 0 3px rgba(74, 144, 226, 0.2);
        }
        .btn-login {
            width: 100%;
            padding: 15px;
            border: none;
            border-radius: 8px;
            background-color: #4A90E2;
            color: white;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        .btn-login:hover {
            background-color: #357ABD;
        }
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 8px;
            font-size: 14px;
            text-align: left;
        }
        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>
<body>

    <div class="login-container">
        <div class="login-header">
            <div class="icon"><i class="fas fa-user-shield"></i></div>
            <h1>Admin Panel</h1>
            <p>Please sign in to continue</p>
        </div>

        <!-- Display login error message if it exists -->
        <?php if (isset($_SESSION['error_message'])): ?>
            <div class="alert alert-danger">
                <?php
                echo e($_SESSION['error_message']);
                unset($_SESSION['error_message']); // Clear message after displaying
                ?>
            </div>
        <?php endif; ?>

        <form action="../actions/admin_login_handler.php" method="POST">
            <div class="form-group">
                <label for="email">Email Address</label>
                <input type="email" id="email" name="email" class="form-control" required autofocus>
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" class="form-control" required>
            </div>
            <button type="submit" class="btn-login">Sign In</button>
        </form>

    </div>

</body>
</html>

