<?php
/**
 * Admin Page: Manage Psychological Tests
 *
 * PERBAIKAN: Path 'include' telah dikoreksi untuk mencocokkan
 * struktur file Anda (tanpa direktori 'partials').
 */

// Mengubah path dari 'admin/partials/admin_header.php'
include THEME_PATH . 'admin/header.php';

// Ambil semua tes dari database
try {
    $pdo = get_db_connection();
    
    $stmt = $pdo->query("
        SELECT 
            pt.id, 
            pt.test_name, 
            pt.description, 
            pt.question_count, 
            pt.test_type,
            a.full_name as admin_name 
        FROM psychological_tests pt
        LEFT JOIN admins a ON pt.created_by_admin_id = a.id
        ORDER BY pt.test_name ASC
    ");
    $tests = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (Exception $e) {
    display_error_message("Database error: " . $e->getMessage());
    $tests = [];
}
?>

<div class="content-wrapper">
    <div class="container-fluid">
        
        <div class="row mb-3">
            <div class="col-md-9">
                <h1><i class="fas fa-tasks"></i> Manage Psychological Tests</h1>
                <p>Tambah, edit, atau kelola pertanyaan untuk tes psikologi platform Anda.</p>
            </div>
            <div class="col-md-3 text-right">
                <a href="index.php?page=add_test" class="btn btn-primary mt-3">
                    <i class="fas fa-plus"></i> Add New Test
                </a>
            </div>
        </div>
        
        <?php
        if (isset($_SESSION['success_message'])) {
            echo '<div class="alert alert-success">' . htmlspecialchars($_SESSION['success_message']) . '</div>';
            unset($_SESSION['success_message']);
        }
        if (isset($_SESSION['error_message'])) {
            echo '<div class="alert alert-danger">' . htmlspecialchars($_SESSION['error_message']) . '</div>';
            unset($_SESSION['error_message']);
        }
        ?>

        <div class="card">
            <div class="card-header">
                <i class="fas fa-table"></i> All Available Tests
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="dataTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Test Name</th>
                                <th>Type</th>
                                <th>Description</th>
                                <th>Questions</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($tests)): ?>
                                <tr>
                                    <td colspan="6" class="text-center">No tests found. Click "Add New Test" to create one.</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($tests as $test): ?>
                                    <tr>
                                        <td><?php echo (int)$test['id']; ?></td>
                                        <td><?php echo htmlspecialchars($test['test_name']); ?></td>
                                        
                                        <td>
                                            <?php
                                            $type_label = htmlspecialchars(strtoupper($test['test_type']));
                                            $badge_class = 'badge-secondary';
                                            if ($test['test_type'] === 'disc') {
                                                $badge_class = 'badge-info';
                                            } elseif ($test['test_type'] === 'papi') {
                                                $badge_class = 'badge-warning';
                                            }
                                            ?>
                                            <span class="badge <?php echo $badge_class; ?>"><?php echo $type_label; ?></span>
                                        </td>
                                        
                                        <td><?php echo htmlspecialchars($test['description'] ?: 'N/A'); ?></td>
                                        <td><?php echo (int)$test['question_count']; ?></td>
                                        
                                        <td>
                                            <?php
                                            $isComplexTest = ($test['test_type'] === 'disc' || $test['test_type'] === 'papi');
                                            $disabledAttr = $isComplexTest ? 'disabled' : '';
                                            $tooltipTitle = $isComplexTest ? 'title="Questions are built-in for this test type and cannot be managed manually."' : 'title="Manage custom questions"';
                                            ?>
                                            
                                            <a href="index.php?page=edit_test&id=<?php echo $test['id']; ?>" class="btn btn-sm btn-info" title="Edit test details">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            
                                            <a href="index.php?page=manage_questions&test_id=<?php echo $test['id']; ?>" 
                                               class="btn btn-sm btn-secondary <?php echo $disabledAttr; ?>" 
                                               <?php echo $tooltipTitle; ?> 
                                               <?php echo $disabledAttr; ?>>
                                                <i class="fas fa-list-ul"></i>
                                            </a>

                                            <form action="actions/test_management_handler.php" method="POST" style="display: inline-block;" onsubmit="return confirm('Are you sure you want to delete this test? This action cannot be undone.');">
                                                <input type="hidden" name="action" value="delete_test">
                                                <input type="hidden" name="test_id" value="<?php echo $test['id']; ?>">
                                                <button type="submit" class="btn btn-sm btn-danger" title="Delete test">
                                                    <i class="fas fa-trash"></i>
                                                </button
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
    </div> </div> <?php
// Mengubah path dari 'admin/partials/admin_footer.php'
include THEME_PATH . 'admin/footer.php';
?>