<?php
/**
 * Standard User Header
 */
?>
<!DOCTYPE html>
<html lang="<?php echo $_SESSION['lang'] ?? DEFAULT_LANG; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(SITE_NAME); ?></title>

    <!-- Google Fonts: Poppins -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">

    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    <!-- FIXED: Main Stylesheet path is now absolute -->
    <link rel="stylesheet" href="<?php echo asset_url('css/style.css'); ?>">

</head>
<body>

    <header class="site-header">
        <div class="container">
            <div class="site-logo">
                <a href="index.php?page=dashboard">
                    <i class="fas fa-brain"></i> <?php echo e(SITE_NAME); ?>
                </a>
            </div>
            <nav class="site-nav">
                <?php if (is_logged_in()): ?>
                    <div class="user-info">
                        <span>Hi, <?php echo e($_SESSION['user_name'] ?? 'User'); ?></span>
                        <a href="logout.php" class="btn-logout" title="Logout">
                            <i class="fas fa-sign-out-alt"></i>
                        </a>
                    </div>
                <?php endif; ?>
            </nav>
        </div>
    </header>

    <main> <!-- This main tag is closed in footer.php -->


