<?php
/**
 * User Login Page
 *
 * This is the theme file for the user login screen.
 */

// We won't include the standard header because the login page has a unique layout.
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once '../../config.php';
require_once '../../app/helpers.php';

// If the user is already logged in, redirect them to the dashboard.
if (is_logged_in()) {
    header('Location: index.php?page=dashboard');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?php echo e(SITE_NAME); ?></title>
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <!-- Main Stylesheet for Auth Pages -->
    <link rel="stylesheet" href="public/themes/default/css/auth-style.css"> <!-- We'll create this CSS file -->
    <style>
        /* Basic styles for auth pages, can be moved to auth-style.css */
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            padding: 20px;
            box-sizing: border-box;
        }
        .auth-container {
            background-color: #ffffff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px B30px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 420px;
            text-align: center;
        }
        .auth-header h1 {
            margin: 0 0 10px 0;
            font-size: 28px;
            color: #333;
            font-weight: 700;
        }
        .auth-header p {
            margin: 0 0 30px 0;
            color: #777;
        }
        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }
        .form-control {
            width: 100%; padding: 12px 15px; border-radius: 8px; border: 1px solid #ddd; font-size: 16px; box-sizing: border-box;
        }
        .btn {
            width: 100%; padding: 14px; border: none; border-radius: 8px; font-size: 16px; font-weight: 600; cursor: pointer; transition: background-color 0.3s, color 0.3s;
        }
        .btn-primary { background-color: #4A90E2; color: white; }
        .btn-primary:hover { background-color: #357ABD; }
        .btn-google { background-color: #fff; color: #555; border: 1px solid #ddd; display: flex; align-items: center; justify-content: center; gap: 10px; }
        .btn-google:hover { background-color: #f7f7f7; }
        .divider { display: flex; align-items: center; text-align: center; color: #aaa; margin: 30px 0; }
        .divider::before, .divider::after { content: ''; flex: 1; border-bottom: 1px solid #ddd; }
        .divider:not(:empty)::before { margin-right: .25em; }
        .divider:not(:empty)::after { margin-left: .25em; }
        .auth-footer { margin-top: 20px; color: #555; }
        .auth-footer a { color: #4A90E2; text-decoration: none; font-weight: 600; }
        .alert { padding: 15px; margin-bottom: 20px; border-radius: 8px; font-size: 14px; text-align: left; }
        .alert-danger { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .alert-success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .extra-links { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; font-size: 14px; }
    </style>
</head>
<body>

    <div class="auth-container">
        <div class="auth-header">
            <h1>Welcome Back!</h1>
            <p>Sign in to continue your AI interview journey.</p>
        </div>

        <!-- Display Messages -->
        <?php if (isset($_SESSION['error_message'])): ?>
            <div class="alert alert-danger"><?php echo e($_SESSION['error_message']); unset($_SESSION['error_message']); ?></div>
        <?php endif; ?>
        <?php if (isset($_SESSION['success_message'])): ?>
            <div class="alert alert-success"><?php echo e($_SESSION['success_message']); unset($_SESSION['success_message']); ?></div>
        <?php endif; ?>

        <form action="actions/user_login_handler.php" method="POST">
            <div class="form-group">
                <input type="email" name="email" class="form-control" placeholder="Email Address" required>
            </div>
            <div class="form-group">
                <input type="password" name="password" class="form-control" placeholder="Password" required>
            </div>
            <div class="extra-links">
                <label><input type="checkbox" name="remember_me"> Remember Me</label>
                <a href="index.php?page=forgot_password">Forgot Password?</a>
            </div>
            <button type="submit" class="btn btn-primary">Sign In</button>
        </form>

        <div class="divider">OR</div>

        <a href="google_sso.php" class="btn btn-google">
            <img src="https://www.google.com/favicon.ico" alt="Google icon" width="20" height="20">
            Sign In with Google
        </a>

        <div class="auth-footer">
            Don't have an account? <a href="index.php?page=register">Sign Up</a>
        </div>
    </div>

</body>
</html>

