<?php
/**
 * User Payment Page
 *
 * This is Step 2 of the AI interview process. This page displays the
 * payment details and integrates the Midtrans Snap payment gateway.
 */

// The main router (index.php) handles session and security checks.
include THEME_PATH . 'header.php'; // Includes the main header

// Get Midtrans Client Key from config
$midtrans_client_key = MIDTRANS_CLIENT_KEY;
$midtrans_is_production = MIDTRANS_IS_PRODUCTION;
$midtrans_snap_url = $midtrans_is_production ? 'https://app.midtrans.com/snap/snap.js' : 'https://app.sandbox.midtrans.com/snap/snap.js';

// Get user details from session for Midtrans
$user_name = $_SESSION['user_name'] ?? 'User';
$user_email = $_SESSION['user_email'] ?? '';

?>

<div class="user-dashboard">
    <div class="container">
        <div class="payment-container">
            <div class="payment-header">
                <div class="step-icon active">2</div>
                <h1><?php echo trans('step_2_title'); ?></h1>
                <p><?php echo trans('step_2_description'); ?></p>
            </div>

            <!-- Session Message Display -->
            <?php if (isset($_SESSION['payment_error'])): ?>
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle"></i>
                    <?php echo e($_SESSION['payment_error']); unset($_SESSION['payment_error']); ?>
                </div>
            <?php endif; ?>

            <div class="payment-details">
                <div class="order-summary">
                    <h3>Order Summary</h3>
                    <div class="summary-item">
                        <span>AI Interview & Profile Analysis</span>
                        <span>Rp 19,900</span>
                    </div>
                    <div class="summary-total">
                        <span>Total</span>
                        <strong>Rp 19,900</strong>
                    </div>
                </div>

                <div class="payment-actions">
                    <button id="pay-button" class="btn btn-primary btn-pay">
                        <i class="fas fa-shield-alt"></i> Bayar Sekarang
                    </button>
                    <small class="secure-payment-info">
                        <i class="fas fa-lock"></i> Transaksi aman dan terenkripsi oleh Midtrans.
                    </small>
                </div>
                 <a href="index.php?page=dashboard" class="back-link">&larr; Kembali ke Dasbor</a>
            </div>

        </div>
    </div>
</div>

<!-- Midtrans Snap JS -->
<script src="<?php echo $midtrans_snap_url; ?>" data-client-key="<?php echo $midtrans_client_key; ?>"></script>

<script>
document.getElementById('pay-button').addEventListener('click', function () {
    const payButton = this;
    // Disable button to prevent multiple clicks
    payButton.disabled = true;
    payButton.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Memproses...';

    // Fetch the transaction token from our server
    fetch('actions/payment_handler.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            amount: 19900,
            user_name: '<?php echo e($user_name); ?>',
            user_email: '<?php echo e($user_email); ?>'
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.token) {
            // Open the Midtrans payment widget
            window.snap.pay(data.token, {
                onSuccess: function(result){
                    // Redirect or update UI on success
                    window.location.href = 'index.php?page=psy_test';
                },
                onPending: function(result){
                    alert("Pembayaran Anda sedang diproses. Kami akan memberitahu Anda setelah selesai.");
                    payButton.disabled = false;
                    payButton.innerHTML = '<i class="fas fa-shield-alt"></i> Bayar Sekarang';
                },
                onError: function(result){
                    alert("Pembayaran gagal. Silakan coba lagi.");
                    payButton.disabled = false;
                    payButton.innerHTML = '<i class="fas fa-shield-alt"></i> Bayar Sekarang';
                },
                onClose: function(){
                    // Re-enable the button if the user closes the widget
                    payButton.disabled = false;
                    payButton.innerHTML = '<i class="fas fa-shield-alt"></i> Bayar Sekarang';
                }
            });
        } else {
            alert(data.error || 'Could not initiate payment. Please try again.');
            payButton.disabled = false;
            payButton.innerHTML = '<i class="fas fa-shield-alt"></i> Bayar Sekarang';
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred. Please check the console and try again.');
        payButton.disabled = false;
        payButton.innerHTML = '<i class="fas fa-shield-alt"></i> Bayar Sekarang';
    });
});
</script>

<style>
/* Add specific styles for the payment page */
.payment-container { max-width: 500px; margin: 40px auto; background: var(--card-bg); padding: 40px; border-radius: 12px; box-shadow: 0 8px 25px rgba(0,0,0,0.08); }
.payment-header { text-align: center; margin-bottom: 30px; }
.payment-header .step-icon { margin: 0 auto 15px auto; }
.payment-header h1 { font-size: 28px; margin: 0 0 10px 0; }
.order-summary { border: 1px solid var(--border-color); border-radius: 8px; margin-bottom: 30px; }
.order-summary h3 { font-size: 18px; padding: 15px; margin: 0; border-bottom: 1px solid var(--border-color); }
.summary-item, .summary-total { display: flex; justify-content: space-between; padding: 15px; }
.summary-total { border-top: 1px solid var(--border-color); font-size: 18px; }
.payment-actions { text-align: center; }
.btn-pay { width: 100%; font-size: 18px; padding: 15px; }
.secure-payment-info { display: block; margin-top: 15px; font-size: 12px; color: var(--text-secondary); }
.back-link { display: block; text-align: center; margin-top: 20px; color: var(--text-secondary); text-decoration: none; font-size: 14px; }
</style>

<?php
// Include the standard user footer.
include THEME_PATH . 'footer.php';
?>

